# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .._models import BaseModel

__all__ = ["FileSearchResultContent", "Result"]


class Result(BaseModel):
    """The result of the File Search."""

    file_search_store: Optional[str] = None
    """The name of the file search store."""

    text: Optional[str] = None
    """The text of the search result."""

    title: Optional[str] = None
    """The title of the search result."""


class FileSearchResultContent(BaseModel):
    """File Search result content."""

    type: Literal["file_search_result"]

    result: Optional[List[Result]] = None
    """The results of the File Search."""
