# --- Configuration ---
import platform
import requests
from typing import Dict, Any

PORT_NUMBER = 8000
PORT_NUMBER2 = 8001

MAX_HISTORY_TURNS = 10
NO_RANKS = 15

#WEBSEARCH_TOOLS = ["tavily", "brave"]
WEBSEARCH_TOOLS = ["tavily", "brave", "duckduckgo"]
DEFAULT_WEBSEARCH_TOOL = WEBSEARCH_TOOLS[0]

# --- LLM Model Configuration ---
GEMINI_MODELS = ['gemini-2.5-flash', 'gemini-2.5-pro','gemini-3-flash-preview','gemini-3-pro-preview']

# =============================================================================
# OS Detection
# =============================================================================
IS_WINDOWS = platform.system() == "Windows"
IS_LINUX = platform.system() == "Linux"
LLM_MODELS = GEMINI_MODELS

CONDENSER_MODEL_GEMINI = GEMINI_MODELS[0]

# =============================================================================
# Functions
# =============================================================================

def g_prog_envs():
    return (
        MAX_HISTORY_TURNS,WEBSEARCH_TOOLS,DEFAULT_WEBSEARCH_TOOL,
        GEMINI_MODELS,LLM_MODELS,CONDENSER_MODEL_GEMINI
    )

def prog_envs():
    RELEVANCE_THRESHOLD = 0.0
    PRINT_SCORE = True
    MODEL_0 = LLM_MODELS[0]
    TIMEOUT = 300
    SHOW_REASON = False
    SHOW_TOOL_REASON = True
    return (
        TIMEOUT,RELEVANCE_THRESHOLD,PRINT_SCORE,MODEL_0,SHOW_REASON, SHOW_TOOL_REASON
    )

def numranks():
    return NO_RANKS

def portnumber():
    return PORT_NUMBER

def portnumber2():
    return PORT_NUMBER2

def rag_mode():
    return "grounded"

def pronun_model():
    return "gemini-2.5-flash-lite"   # 저렴 (오디오 $0.30/1M)
    # return "gemini-2.5-flash"      # 정확 (오디오 $1.00/1M)